/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.utils.collections.adapters;

import cz.cuni.amis.pogamut.base.agent.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldObjectEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.objects.IViewable;
import cz.cuni.amis.utils.collections.ObservableSet;
import java.util.HashSet;

/**
 * Provides set of all visible world objects extending some class as observable set.
 * @author ik
 */
public class WVVisibleObjectsSetAdapter<T extends IViewable> extends ObservableSet<T> {

    WorldObjectEventListener<T> addListener;
    WorldObjectEventListener<T> remListener;

    public WVVisibleObjectsSetAdapter(Class<T> cls, IWorldView worldView) {
        super(new HashSet<T>());
        // register listener
        worldView.addAppearedListener(cls, addListener = new WorldObjectEventListener<T>() {

            @Override
            public void notify(T event) {
                add(event);
            }
        });

        worldView.addDisappearedListener(cls, remListener = new WorldObjectEventListener<T>() {

            @Override
            public void notify(T event) {
                remove(event);
            }
        });

        // add the data
        addAll(worldView.getAll(cls).values());
    }
}
