package cz.cuni.amis.utils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MyCollections {
	
	public static <T> List<T> asList(T[] objects) {
		if (objects == null) return null;
		List<T> list = new ArrayList<T>(objects.length);
		for (T object : objects) {
			list.add(object);
		}
		return list;
	}
	
	public static <T> List<T> asList(Collection<T> objects) {
		if (objects == null) return null;
		List<T> list = new ArrayList<T>(objects.size());
		for (T object : objects) {
			list.add(object);
		}
		return list;
	}
	
	public static String toString(Object objToString, String[] prefixes, String[] postfixes, String[] separators, IToString toString) {
		
		StringBuffer sb = new StringBuffer(200);
		
		String[] newPrefixes = null;
		String[] newPostfixes = null;
		String[] newSeparators = null;
		
		boolean first = true;
		
		sb.append(prefixes != null && prefixes.length > 0 ? prefixes[0] : "");
		
		String separator = separators != null && separators.length > 0 ? separators[0] : "";
		
		if (objToString.getClass().isArray()) {
			objToString = asList((Object[])objToString);
		}
		if (objToString instanceof Collection) {
		
			for (Object obj : (Collection)objToString) {
				
				if (first) first = false;
				else sb.append(separator);
					
				if (obj instanceof Collection) {
					if (newPrefixes == null) {
						if (prefixes != null && prefixes.length > 1) {
							newPrefixes = new String[prefixes.length-1];
							System.arraycopy(prefixes, 1, newPrefixes, 0, prefixes.length-1);
						} else {
							newPrefixes = new String[0];
						}
						if (postfixes != null && postfixes.length > 1) {
							newPostfixes = new String[postfixes.length-1];
							System.arraycopy(postfixes, 1, newPostfixes, 0, postfixes.length-1);
						} else {
							newPostfixes = new String[0];
						}
						if (separators != null && separators.length > 1) {
							newSeparators = new String[separators.length-1];
							System.arraycopy(separators, 1, newSeparators, 0, separators.length-1);
						} else {
							newSeparators = new String[0];
						}
					}
					sb.append(MyCollections.toString((Collection) obj, newPrefixes, newPostfixes, newSeparators, toString));
				} else {
					sb.append(toString.toString(obj));
				}
			}
		} else {
			sb.append(toString.toString(objToString));
		}
			
		sb.append(postfixes != null && postfixes.length > 0 ? postfixes[0] : "");
		
		return sb.toString();
	}

	public static String toString(Object obj, String prefix, String postfix, String separator) {
		return toString(obj, new String[]{prefix}, new String[]{postfix}, new String[]{separator}, TO_STRING );
	}
	
	public static String toString(Object obj, String prefix, String postfix, String separator, IToString toString) {
		return toString(obj, new String[]{prefix}, new String[]{postfix}, new String[]{separator}, toString );
	}
	
	public static final IToString TO_STRING = new IToString() {

		@Override
		public String toString(Object obj) {
			return obj.toString();
		}
		
	};
	
	public static interface IToString {
		
		public String toString(Object obj);
		
	}

}
