/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.utils.collections;

import java.util.Collection;

/**
 * Simple listener called for each element that has changed even in batch updates.
 * @author ik
 */
public abstract class ElementListener<T> extends SimpleListener<T> {

    /**
     * Called each time an element changes.
     * @param elem
     * @param added
     */
    public abstract void elementChanged(T elem, boolean added);

    @Override
    protected void changed(Collection<T> collection, boolean added) {
        for (T elem : collection) {
            elementChanged(elem, added);
        }
    }
}
