package cz.cuni.amis.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HashMapSetSync<KEY, ITEM> {
	
	private Map<KEY, Set<ITEM>> map = Collections.synchronizedMap(new HashMap<KEY, Set<ITEM>>());
	
	public Set<ITEM> get(KEY primaryKey) {
		synchronized(map) {
			Set<ITEM>set = map.get(primaryKey);
			if (set != null) return set;
			set = Collections.synchronizedSet(new HashSet<ITEM>());
			map.put(primaryKey, set);
			return set;
		}
	}
	
	public void put(KEY primaryKey, ITEM item) {
		Set<ITEM> set = get(primaryKey);
		set.add(item);		
	}

	public void remove(Object key) {
		map.remove(key);
	}
	
}
