package cz.cuni.amis.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HashMapSet<KEY, ITEM> {
	
	private Map<KEY, Set<ITEM>> map = new HashMap<KEY, Set<ITEM>>();
	
	public Set<ITEM> get(KEY primaryKey) {
		synchronized(map) {
			Set<ITEM>set = map.get(primaryKey);
			if (set != null) return set;
			set = new HashSet<ITEM>();
			map.put(primaryKey, set);
			return set;
		}
	}
	
	public void put(KEY primaryKey, ITEM item) {
		Set<ITEM> set = get(primaryKey);
		synchronized(set) {
			set.add(item);
		}
	}

	public void remove(Object key) {
		synchronized(map) {
			map.remove(key);
		}
	}
	
}
