package cz.cuni.amis.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HashMapList<KEY, ITEM> {
	
	private Map<KEY, List<ITEM>> map = new HashMap<KEY, List<ITEM>>();
	
	public List<ITEM> get(KEY key) {
		synchronized(map) {
			List<ITEM> list = map.get(key);
			if (list != null) return list;
			list = new ArrayList<ITEM>();
			map.put(key, list);
			return list;
		}
	}
	
	public void add(KEY key, ITEM item) {
		List<ITEM> list = get(key);
		synchronized(list) {
			list.add(item);
		}
	}
	
	public void remove(KEY key) {
		synchronized(map) {
			map.remove(key);
		}
	}
	
	public Set<KEY> keys() {
		return map.keySet();
	}

	public void clear() {
		map.clear();
	}

}