package cz.cuni.amis.pogamut.base.utils.logging;

import java.util.logging.Handler;
import java.util.logging.LogRecord;

/**
 * Handler for the messages - instantiated without publisher.
 * <p><p>
 * Use setPublisher() or constructor with ILogPublisher parameter.
 * <p><p>
 * See LogPublisher and it's public static inner classes ConsolePublisher and FilePublisher.
 *  
 * @author Jimmy
 *
 */
public class LogHandler extends Handler implements Cloneable {
	
	
	protected ILogPublisher publisher = null;
	public LogHandler() {		
	}
	
	public LogHandler(ILogPublisher publisher) {
		this.publisher = publisher;
	}
	
	public ILogPublisher getPublisher() {
		return publisher;
	}

	public void setPublisher(ILogPublisher publisher) {
		this.publisher = publisher;
	}
	
	@Override
	public void close() throws SecurityException {
		ILogPublisher actualPublisher = publisher;		
		if (actualPublisher != null) actualPublisher.close();		
	}

	@Override
	public void flush() {
		ILogPublisher actualPublisher = publisher;		
		if (actualPublisher != null) actualPublisher.flush();		
	}

	@Override
	public void publish(LogRecord record) {
		ILogPublisher actualPublisher = publisher;		
		if (actualPublisher != null) actualPublisher.publish(record);
	}

}
