package cz.cuni.amis.pogamut.base.utils;

import javax.management.MBeanServer;

import cz.cuni.amis.pogamut.base.agent.exceptions.CantStartJMXException;
import cz.cuni.amis.pogamut.base.agent.exceptions.JMXAlreadyEnabledException;

/**
 * Interface for enabling JMX on some feature.
 * <p><p>
 * This interface is marking that class supports JMX somehow and can be added to the agent who
 * will call this method whenever this method is called on the whole agent.
 * 
 * @author Jimmy
 */
public interface IJMXEnabled {
	
	/**
	 * Method for starting the JMX extension of the class. 
	 * <p><p>
	 * Object should register whatever objects it wants to expose via JMX.
	 * 
	 * @param mBeanServer server where the MBean of agent is registered
	 * @param jmxDomain domain where the MBean of agent is registered
         * @param path type key under which the MBeans should be registered, 
         * hierarchical types are made with . notation eg. "parentType.myType"
	 * @throws JMXAlreadyEnabledException
	 */
	public void enableJMX(MBeanServer mBeanServer, String jmxDomain, String path) throws JMXAlreadyEnabledException, CantStartJMXException;
	
}
