/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.base.utils;

import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.IntrospectionException;
import cz.cuni.amis.introspection.jmx.FolderMBean;
import cz.cuni.amis.pogamut.base.agent.exceptions.CantStartJMXException;
import cz.cuni.amis.pogamut.base.agent.exceptions.JMXAlreadyEnabledException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;

/**
 * Adapter turning introspection folder into IJMXEnabled component. 
 * @author Ik
 */
public class FolderToIJMXEnabledAdapter implements IJMXEnabled {

    /** Folder being adapted. */
    Folder folder = null;

    public FolderToIJMXEnabledAdapter(Folder folder) {
        this.folder = folder;
    }

    public void enableJMX(MBeanServer mBeanServer, String jmxDomain, String type) throws JMXAlreadyEnabledException, CantStartJMXException {
        try {
            FolderMBean.exportFolderHierarchy(folder, mBeanServer, jmxDomain, type);
        } catch (Exception ex) {
            throw new CantStartJMXException("Failed to export an introspection folder to JMX server.", ex);
        }
    }
}
