package cz.cuni.amis.pogamut.base.factory;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;

/**
 * Factory interface that provides a way for obtaining a new agent instance.
 * @author Jimmy
 *
 * @param <ADDRESS>
 */
public interface IAgentFactory<ADDRESS extends IWorldConnectionAddress> {

	/**
	 * Factory method, must do two things:<p>
	 * <ol>
	 * <li>create new IAgent instance</li>
	 * <li>connect it to the world that is at 'address'</li>
	 * </ol>
	 * <p><p>
	 * If no exception is thrown, we're assuming:
	 * <ul>
	 * <li>agent is created</li>
	 * <li>connection to the world was successfully set up</li>
	 * </ul>
	 * <p><p>
	 * <b>MUST NOT START THE AGENT!</b>
	 *  
	 * @param address
	 * @return
	 * @throws PogamutException
	 */
	public IAgent newAgent(ADDRESS address) throws PogamutException;

}
