package cz.cuni.amis.pogamut.base.communication.translator;

import cz.cuni.amis.pogamut.base.communication.exceptions.TranslatorException;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;

/**
 * This is handler for messages that should produce IWorldChangeEvent(s) out of
 * messages we receive from the world.
 * @author Jimmy
 */
@AgentScoped
public interface IWorldMessageTranslator {

	/**
	 * The handler must process the message and return 0,1 or more world events.
	 * @param message
	 * @return
	 */
	public IWorldChangeEvent[] processMessage(InfoMessage message) throws TranslatorException;
	
}
