package cz.cuni.amis.pogamut.base.communication.translator;

import com.google.inject.ImplementedBy;

import cz.cuni.amis.pogamut.base.communication.exceptions.CommunicationException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.IControllable;

/**
 * Interface providing events from the world.
 * @author Jimmy
 */
@ImplementedBy(WorldEventOutput.class)
@AgentScoped
public interface IWorldEventOutput extends IControllable {

	/**
	 * When called should return next event of the world.
	 * <p><p>
	 * May block.
	 * 
	 * @return
	 */
	public IWorldChangeEvent getEvent() throws CommunicationException;
	
	/**
	 * Starts the producer - must be called before the first getEvent() call is made
	 * to let the producer initialize itself.
	 */
	@Override
	public void start() throws CommunicationException;
	
	/**
	 * Close the event producer.
	 */
	@Override
	public void stop();
	
	/**
	 * Usually does the same as the stop(). 
	 */
	@Override
	public void kill();
	
}