package cz.cuni.amis.pogamut.base.communication.parser;

import com.google.inject.ImplementedBy;

import cz.cuni.amis.pogamut.base.communication.exceptions.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.IControllable;

/**
 * Message parser has a method for reading and parsing messages from the world.
 * <p><p>
 * It should be initialized with IWorldReaderProvider and implement serialization of the
 * message to string.
 * 
 * @author Jimmy
 */
@ImplementedBy(Parser.class)
@AgentScoped
public interface IWorldMessageParser extends IControllable {
	
	/**
	 * May block.
	 * <BR><BR>
	 * Should get and parse next message from the reader.
	 * 
	 * @return parsed message
	 */
	public InfoMessage parse() throws CommunicationException;
	
	/**
	 * Starts the parser - called usually from the mediator when it starts.
	 * <p><p>
	 * It should prepare the object for future parse() calls.
	 * 
	 * @throws ParserException 
	 */
	@Override
	public void start() throws CommunicationException;
	
	/**
	 * Stops the parser, it should close the underlaying reader (or any other resources).
	 */
	@Override
	public void stop();
	
	/**
	 * Usually doesn't do anything else then stop().
	 */
	@Override
	public void kill();
	
}