package cz.cuni.amis.pogamut.base.communication.mediator;

import com.google.inject.ImplementedBy;

import cz.cuni.amis.pogamut.base.agent.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;

/**
 * Input interface for the world view. WorldView receives new events through this interface.
 * 
 * @author Jimmy
 */
@AgentScoped
@ImplementedBy(IWorldView.class)
public interface IMediatorOutput {

	/**
	 * New event was generated from the world.
	 * 
	 * @param event
	 */
	public void notify(IWorldChangeEvent event);
    
}
