package cz.cuni.amis.pogamut.base.communication.mediator;

import java.util.concurrent.Future;

import com.google.inject.ImplementedBy;

import cz.cuni.amis.pogamut.base.communication.exceptions.CommunicationException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.IControllable;
import cz.cuni.amis.utils.flag.ImmutableFlag;

@ImplementedBy(Mediator.class)
@AgentScoped
public interface IMediator extends IControllable {
	
	/**
	 * Starts the mediator - it's IWorldEventInput should be defined in constructor.
	 */
	@Override
	public void start() throws CommunicationException;
	
	/**
	 * Unconditionally stop the communication thread + <b>close</b> the connection.
	 * <p><p>
	 * If possible this should not produce any excpetions...
	 * <BR><BR>
	 * Listeners should be cleared in this point (those who want it...).
	 */
	public void stop();
	
	/**
	 * Unconditionally stop the communication thread + <b>close</b> the connection.
	 * <p><p>
	 * This should be done the hard way (not just dropping some flags but interrupting
	 * threads as well).
	 * <p><p>
	 * Listeners should be cleared in this point (those who want it...).
	 */
	public void kill();
		
	/**
	 * Whether the mediator is running and processing messages through the current handler.
	 * @return
	 */
	public ImmutableFlag<Boolean> getRunning();


    public void setMediatorOutput(IMediatorOutput receiver);
}