/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.base.communication.connection.socket;

import java.net.URI;
import java.net.URL;

/**
 * Simple implementation of the interface ISocketConnectionAddress.
 * @author Jimmy
 *
 */
public class SocketConnectionAddress implements ISocketConnectionAddress {

    private String host;
    private int port;

    public SocketConnectionAddress(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public SocketConnectionAddress(URL url) {
        this.host = url.getHost();
        this.port = url.getPort();
    }

    public SocketConnectionAddress(URI uri) {
        this.host = uri.getHost();
        this.port = uri.getPort();
    }

    @Override
    public String getHost() {
        return host;
    }

    @Override
    public int getPort() {
        return port;
    }
    
    public String toString() {
    	return "SocketConnectionAddress[" + host + ":" + port + "]";
    }
}