package cz.cuni.amis.pogamut.base.communication.connection;

import java.io.Reader;

import com.google.inject.ImplementedBy;

import cz.cuni.amis.pogamut.base.communication.exceptions.ConnectionException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;

/**
 * Interface that returns a reader that can be used to get messages from the world.
 * @author Jimmy
 */
@ImplementedBy(IWorldConnection.class)
@AgentScoped
public interface IWorldReaderProvider {
	
	/**
	 * To be used by (usually) IParser upon IParser.start() method call to obtain a world reader.
	 * <p><p>
	 * Use reader.close() to close the connection.
	 * 
	 * @return
	 * @throws ConnectionException
	 */
	public Reader getReader() throws ConnectionException;
	
}
