package cz.cuni.amis.pogamut.base.communication.commands;

import com.google.inject.ImplementedBy;

import cz.cuni.amis.pogamut.base.communication.exceptions.CommandException;
import cz.cuni.amis.pogamut.base.communication.exceptions.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.IControllable;

/**
 * Command serializer has method for sending command object to the world.
 * <p><p>
 * It should be initialized with IWorldWriterProvider and implement serialization of the
 * message to string.
 * 
 * @author Jimmy
 */
@AgentScoped
@ImplementedBy(CommandSerializer.class)
public interface ICommandSerializer extends IControllable {
	
	/**
	 * Sends command through the writer.
	 * 
	 * @param command
	 * @throws CommunicationException
	 */
	public void sendCommand(CommandMessage command) throws CommunicationException;
	
	/**
	 * Should prepare and start the command serializer.
	 * @throws CommunicationException
	 */
	@Override
	public void start() throws CommunicationException;
	
	/**
	 * Closes the writer.
	 */
	@Override
	public void stop();
	
	/**
	 * Usually doesn't do anything else then stop().
	 */
	@Override
	public void kill();

}
