package cz.cuni.amis.pogamut.base.communication.commands;

import com.google.inject.ImplementedBy;

import cz.cuni.amis.pogamut.base.communication.exceptions.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;

/**
 * IAct provides a way to send command messages to the world allowing you to attach
 * listeners to outgoing commands.
 * 
 * @author Jimmy
 */
@AgentScoped
@ImplementedBy(Act.class)
public interface IAct {
	
	/**
	 * Execute an action in the world.
	 * <p><p>
	 * May block.
	 * <p><p>
	 * Should serialize the command object and send it through the writer.
	 * 
	 * @return parsed message
	 */
	public void act(CommandMessage command) throws CommunicationException;
	
	/**
	 * Attach listener to outgoing commands from body.
	 * <p><p>
	 * After the command is sent to the world, listener will be notified.
	 * <p><p>
	 * The listener is attached via weak reference!
	 * 
	 * @param listener
	 */
	public void addCommandListener(ICommandListener listener);
	
	/**
	 * Remove the listener to outgoing commands.
	 * 
	 * @param listener
	 */
	public void removeCommandListener(ICommandListener listener);

}
