package cz.cuni.amis.pogamut.base.agent.worldview.objects;

import cz.cuni.amis.utils.SafeEquals;

/**
 * StringId for world objects.
 * 
 * @author Jimmy
 */
public class StringId implements IWorldObjectId {
	
	private String id;
	
	public StringId(String id) {
		this.id = id;
	}

	@Override
	public String getStringId() {
		return id;
	}
	
	public int hashCode() {
		return id.hashCode();
	}
	
	public boolean equals(Object obj) {
		if (obj instanceof StringId) {
			return SafeEquals.equals(this.id, ((StringId)obj).id);
		} else {
			return false;
		}
	}

}
