package cz.cuni.amis.pogamut.base.agent.worldview.objects;

import cz.cuni.amis.pogamut.base.communication.translator.IWorldChangeEvent;

/**
 * Interface for the event that suppose to update the informations about the
 * object in the world.
 * <p><p>
 * Each event should return an id of the object it is meant to update, this
 * event is processed by the IWorldViewEventInput implementor that should
 * look up the object in it's view and update it with the method defined
 * by the implementor of this interface.
 * <p><p>
 * This event has <b>three different interpretation</b> according to the behavior of the
 * update() method and the id returned from the event.
 * <ol>
 * <li><b>new object appeared in the world</b> - this is the case when the object's id is
 * unknown to the world view thus 'null' is passed to the update() method AND update() 
 * returns new world object</li>
 * <li><b>update state of the existing object in the world</b> - this is the case
 * when the object's id is known to the world view so the according world object is passed
 * to the update() method AND update() returns the same instance (but updated)
 * of the world object</li>
 * <li><b>object disappeared from the world</b> - this is the case when the object's id
 * id known to the world, according world object is passed to the update() method AND update()
 * method returns null</li>
 * </ol>
 * <p>
 * <b>It's forbidden for the instance of update event to create a new world object instance in the
 * 2) case, it must always work over the instance passed to the update() method</b>
 * <p><p>
 * For the case 1) and 3) EventDrivenWorldView will generate WorldObjectAppearedEvent,
 * resp. WorldObjectDisappearedEvent. For the 2) the EventDrivenWorldView will generate WorldObjectUpdatedEvent. 
 * 
 * @author Jimmy
 */
public interface IWorldObjectUpdateEvent extends IWorldChangeEvent {
	
	public IWorldObjectId getId();
	
	public IWorldObject update(IWorldObject obj);

}
