package cz.cuni.amis.pogamut.base.agent.worldview.objects;

/**
 * Interface for all objects that can be found in the world.
 *  
 * @author Jimmy
 */
public interface IWorldObject {
	
	/**
	 * Returns an id of the object that is unique among all world objects.
	 * @return
	 */
	public IWorldObjectId getId();
	
	/**
	 * Returns world time when the object was seen for the last time.
	 * <br><br>
	 * The time suppose to be growing as the simulation carries on.
	 * <br>
	 * Always should be actual_timestamp >= any_prevously_recorded_timestamp,
	 * <br>
	 * timestamp1 > timestamp2 means the timestamp1 is newer then timestamp2.
	 * 
	 * @return
	 */
	public double getLastSeenTime();
	
}
