/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.base.agent.worldview;

import com.google.inject.ImplementedBy;

import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.IControllable;
import cz.cuni.amis.utils.flag.Flag;

/**
 * Worldview that can be started - the Pogamut is designed so the World view takes
 * as a parameter mediator, that is "dead = not started yet" allowing the user of the
 * world view to register listeners before anything is processed (not to miss
 * first few events).
 * 
 * @author Ik
 */
@AgentScoped
// TODO I think that this isn't necessary @ImplementedBy(EventDrivenWorldView.class)
public interface IStartableWorldView extends IWorldView, IControllable {
	
    /**
     * Starts the world view and bind it to the world instance.
     * This method starts the communication between world and the world view.
     * Agent should register all the listeners on this world view before this 
     * method is called. Otherwise there is a risk that some events will 
     * be missed. 
     */
	@Override
    void start() throws PogamutException;
    
	@Override
    void stop();
    
	@Override
    void kill();
	
	Flag<Boolean> getRunning();
}
