package cz.cuni.amis.pogamut.base.agent.worldview;

public interface ILockableWorldView extends IWorldView {
	
	/**
	 * Lock the worldview, preventing it from raising any new events.
	 * <p><p>
	 * When locked the worldview must store all incoming events and
	 * process them during unlock.
	 * <p><p>
	 * Note that it is implementation-dependent whether this method is blocking or not.
	 */
	public void lock() throws InterruptedException;
	
	/**
	 * Unlock the worldview, processing all events that came between lock() / unlock() calls.
	 */
	public void unlock();
	
	/**
	 * Whether the worldview is locked.
	 * @return
	 */
	public boolean isLocked();
	
}
