/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.base.agent.navigation;

import java.util.List;

/**
 * Interface for generic path planner. PathPlanner is responsible for finding 
 * paths between two points in the level. 
 * 
 * There are several ways how to implement this interface, eg. Dijkstra, A*, 
 * external A* from the UT ...
 * It would be handy to have general wrapper CachedPathPlanner (it will cache
 * commonly requested paths but the paths will be computed by any of the PathPlanner
 * implementations)
 * 
 * Bot programmers will be able to supply their own implementation of PathPlanner,
 * eg. for cars or flying vehicles, or path planners that aren't computing the 
 * shortest path but paths with some other property (eg. paths without 
 * jumps, movers etc.)
 * 
 * PathPlanner should be independent of the bot.
 * @author Ik
 */
public interface PathPlanner<LOCATION, PATH_ELEMENT> {
    
    /**
     * Computes path between two points. Immediately returns the aproximate path.
     * More accurate path may be computed in background and asynchronously returned
     * later through PathPlannerListener.
     * @param from Start of the path.
     * @param to Destination of the path
     * @return aproximate path from the start to the destination.
     * @throws cz.cuni.amis.pogamut.Client.navigation.PathNotConstructable
     *  when no such path exists
     */
    List<PATH_ELEMENT> computePath(LOCATION from, LOCATION to) throws PathNotConstructable;

    /**
     * Registers listener that will be called when the path is computed.
     * @param listener
     */
    public void addPathListener(PathPlannerListener listener);

    public boolean removePathListener(PathPlannerListener listener);
}
