package cz.cuni.amis.pogamut.base.agent.navigation;

import cz.cuni.amis.pogamut.base3d.worldview.objects.ILocated;


/**
 * Makes bot to follow the computed path. It is responsibility of path
 * executor to handle elevators, laders, jumps etc.
 * 
 * Steering can be implemented at this layer.
 * @author Ik
 */
public interface PathExecutor<LOC> {

    /**
     * Makes the agent go to the location. Events are fired at different stages
     * of movement.
     * @param location target location
     */
    public void goTo(LOC location);

    /**
     * Adds listener on events that can emerge during movement along path.
     * @param pathListener
     */
    public void addPathListener(PathExecutorListener pathListener);

    /**
     * Removes path listener.
     * @param pathListener
     */
    public void removePathListener(PathExecutorListener pathListener);
}
