/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.base.agent.navigation;

import java.util.ArrayList;
import java.util.List;

/**
 * 
 * @author ik
 */
public abstract class AbstractPathPlanner<LOCATION, PATH_ELEMENT> implements PathPlanner<LOCATION, PATH_ELEMENT> {

    protected List<PathPlannerListener<PATH_ELEMENT>> listeners = new ArrayList<PathPlannerListener<PATH_ELEMENT>>();

    /**
     * Notify all listeners that new, more accurate path has been computed.
     * @param path new path
     */
    protected void firePathEvent(List<PATH_ELEMENT> path) {
        PathPlannerListener[] temp = listeners.toArray(new PathPlannerListener[0]);
        for(PathPlannerListener listener : temp) {
            listener.pathEvent(path);
        }
    }

    @Override
    public void addPathListener(PathPlannerListener listener) {
        listeners.add(listener);
    }

    @Override
    public boolean removePathListener(PathPlannerListener listener) {
        return listeners.remove(listener);
    }

}
