package cz.cuni.amis.pogamut.base.agent.navigation;

import java.util.ArrayList;
import java.util.List;

/**
 * Default base for path executors. Provides support for firing events.
 * @author ik
 */
public abstract class AbstractPathExecutor<LOC> implements PathExecutor<LOC> {

    protected List<PathExecutorListener> listeners = new ArrayList<PathExecutorListener>();

    /**
     * Notify all listeners.
     * @param eventType
     */
    protected void fireEvent(PathEventType eventType) {
        PathExecutorListener[] tempList = listeners.toArray(new PathExecutorListener[0]);
        for(PathExecutorListener listener : tempList) {
            listener.onEvent(eventType);
        }
    }

    @Override
    public void addPathListener(PathExecutorListener pathListener) {
        listeners.add(pathListener);
    }

    @Override
    public void removePathListener(PathExecutorListener pathListener) {
        listeners.remove(pathListener);
    }
}
