/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.base.agent.jmx;

import cz.cuni.amis.pogamut.base.agent.AgentState;
import cz.cuni.amis.pogamut.base.agent.AgentStateType;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import javax.management.NotificationEmitter;

/**
 * @author Ik
 */
public interface AgentMBeanAdapterMBean extends NotificationEmitter {

	/**
	 * Returns the state of the agent, contains also a String information with detail message
	 * describing the state.
	 * @return
	 */
    public AgentState getAgentState();

    /**
     * Attempt to launch the agent.
     * <BR><BR>
     * Returns Future with the result of the start, it's get() method will block until
     * the agent reaches one of it's "ok" or "end" states (see AgentState doc).
     * 
     * @return future object describing success, whether the agent has been started or not.
     * @throws AgentException
     */
    public void start() throws AgentException;

    public void pause() throws AgentException;

    /**
     * This should resume the logic of the agent. It should also be reflected in the agent state.
     * <BR><BR>
     * If your agent can't be paused therefore can't be resumed,
     * throw OperationNotSupportedException.
     * 
     * @return
     */
    public void resume() throws AgentException;

    /**
     * Attempt to stop the agent, usually meaning dropping all running flags and see whether
     * it will stop automatically. 
     */
    public void stop() throws AgentException;

    /**
     * Stops the agent (unconditionally), closing whatever connection it may have, this
     * method must be non-blocking + interrupting all the communication, logic, whatever
     * threads the agent have.
     */
    public void kill();
}
