package cz.cuni.amis.pogamut.base.agent;

/**
 * Wrapper for the AgentStateType adding additional String information that provides
 * more details about the agent state.
 * <p><p>
 * WARNING: equals() defined according to it's type only! (Doesn't take the description into account.)
 * 
 * @author Jimmy
 */
public class AgentState {
	
	private AgentStateType type;
	private String description;

	public AgentState(AgentStateType type, String description) {
		this.type = type;
		this.description = description;
	}
	
	public boolean equals(Object o) {
		if (!(o instanceof AgentState)) return false; 
		AgentState state = (AgentState)o;
		return type.equals(state.type);
	}

	public AgentStateType getType() {
		return type;
	}

	public String getDescription() {
		return description;
	}
	
	public String toString() {
		return "AgentState[" + type + ", " + description + "]";
	}
	
}
