/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.fsm;

import cz.cuni.amis.fsm.FSM.StateWrapper;
import cz.cuni.amis.fsm.FSM.TransitionWrapper;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;

/**
 * Printer creating a Graphviz .dot file from the instantiated FSM.
 * @author ik
 */
public class FSMDotPrinter { 

    /**
     * Print the FSM to a Graphviz .dot format file.
     * @param fsm FSM to print
     * @param out output stream
     * @param graphName name of the FSM graph
     */
    public static void print(FSM fsm, OutputStream out, String graphName) {
       PrintStream pout = new PrintStream(out);
       pout.println("digraph " + graphName + " {");
       // print all states
       for(Object state : fsm.getStates()) {
           StateWrapper wrapper = (StateWrapper) state;
           String fromStr = wrapper.getWrappedState().getClass().getSimpleName();
           // and print all reachable states together with symbols triggering this transition
           for(Object transEntryObj : wrapper.getTransitions().entrySet()) {
               Map.Entry<Class, TransitionWrapper> transEntry = (Map.Entry<Class, TransitionWrapper>)transEntryObj;
               String symbolStr = transEntry.getKey().getSimpleName();
               String toStr;
               StateWrapper target = transEntry.getValue().getTarget();
               if(target != null) {
                   toStr = target.getWrappedState().getClass().getSimpleName();
               } else {
                   // back link
                   toStr = fromStr;
               }
               pout.println(fromStr + " -> " + toStr + " [label=\"" +  symbolStr + "\"];");
           }
       }
       pout.println("}");
    } 
}
