/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import org.j3d.geom.PolyVertex;
import org.j3d.util.HashSet;
import org.j3d.util.ObjectArray;

class EarCutTriangulator {
    private static final int DEFAULT_POLY_SIZE = 6;
    private static ObjectArray vertexCache = new ObjectArray();
    private HashSet concaveVertices;
    private float[] faceNormal;
    private float[] working2dCoords;
    private PolyVertex[] tmpArray;

    EarCutTriangulator() {
        this(6);
    }

    EarCutTriangulator(int n) {
        this.concaveVertices = new HashSet(n);
        this.faceNormal = new float[3];
        this.working2dCoords = new float[6];
        this.tmpArray = new PolyVertex[n];
    }

    public int triangulateConcavePolygon(float[] fArray, int n, int n2, int[] nArray, int n3, int[] nArray2, int n4, int[] nArray3, int n5, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7, int[] nArray8, float[] fArray2) {
        if (n2 < 3) {
            return 0;
        }
        if (n2 == 3) {
            nArray5[0] = nArray[n];
            nArray5[1] = nArray[n + 1];
            nArray5[2] = nArray[n + 2];
            if (nArray6 != null) {
                nArray6[0] = nArray2[n3];
                nArray6[1] = nArray2[n3 + 1];
                nArray6[2] = nArray2[n3 + 2];
            }
            if (nArray7 != null) {
                nArray7[0] = nArray3[n4];
                nArray7[1] = nArray3[n4 + 1];
                nArray7[2] = nArray3[n4 + 2];
            }
            if (nArray8 != null) {
                nArray8[0] = nArray4[n5];
                nArray8[1] = nArray4[n5 + 1];
                nArray8[2] = nArray4[n5 + 2];
            }
            return 1;
        }
        this.faceNormal[0] = fArray2[0];
        this.faceNormal[1] = fArray2[1];
        this.faceNormal[2] = fArray2[2];
        if (n2 > this.tmpArray.length) {
            this.tmpArray = new PolyVertex[n2];
        }
        int n6 = nArray[n];
        PolyVertex polyVertex = EarCutTriangulator.newVertex();
        polyVertex.x = fArray[n6 * 3];
        polyVertex.y = fArray[n6 * 3 + 1];
        polyVertex.z = fArray[n6 * 3 + 2];
        polyVertex.vertexIndex = n6;
        if (nArray3 != null) {
            polyVertex.colorIndex = nArray3[n4];
        }
        if (nArray2 != null) {
            polyVertex.normalIndex = nArray2[n3];
        }
        if (nArray4 != null) {
            polyVertex.texCoordIndex = nArray4[n5];
        }
        if (!EarCutTriangulator.isConvexVertex(fArray, nArray[n + n2 - 1] * 3, nArray[n] * 3, nArray[n + 1] * 3, this.faceNormal)) {
            this.concaveVertices.add((Object)polyVertex);
        }
        PolyVertex polyVertex2 = polyVertex;
        PolyVertex polyVertex3 = polyVertex;
        int n7 = 1;
        for (int i = n + 1; i < n + n2 - 1; ++i) {
            n6 = nArray[i];
            polyVertex2 = EarCutTriangulator.newVertex();
            polyVertex2.x = fArray[n6 * 3];
            polyVertex2.y = fArray[n6 * 3 + 1];
            polyVertex2.z = fArray[n6 * 3 + 2];
            polyVertex2.vertexIndex = n6;
            if (nArray3 != null) {
                polyVertex2.colorIndex = nArray3[n4 + n7];
            }
            if (nArray2 != null) {
                polyVertex2.normalIndex = nArray2[n3 + n7];
            }
            if (nArray4 != null) {
                polyVertex2.texCoordIndex = nArray4[n5 + n7];
            }
            if (!EarCutTriangulator.isConvexVertex(fArray, nArray[i - 1] * 3, nArray[i] * 3, nArray[i + 1] * 3, this.faceNormal)) {
                this.concaveVertices.add((Object)polyVertex2);
            }
            polyVertex2.prev = polyVertex3;
            polyVertex3.next = polyVertex2;
            polyVertex3 = polyVertex2;
            ++n7;
        }
        n6 = nArray[n + n2 - 1];
        if (fArray[n6 * 3] == fArray[nArray[n] * 3] && fArray[n6 * 3 + 1] == fArray[nArray[n] * 3 + 1] && fArray[n6 * 3 + 2] == fArray[nArray[n] * 3 + 2]) {
            polyVertex2.next = polyVertex;
            polyVertex.prev = polyVertex2;
        } else {
            PolyVertex polyVertex4 = EarCutTriangulator.newVertex();
            polyVertex4.x = fArray[n6 * 3];
            polyVertex4.y = fArray[n6 * 3 + 1];
            polyVertex4.z = fArray[n6 * 3 + 2];
            polyVertex4.vertexIndex = n6;
            if (nArray3 != null) {
                polyVertex4.colorIndex = nArray3[n4 + n2 - 1];
            }
            if (nArray2 != null) {
                polyVertex4.normalIndex = nArray2[n3 + n2 - 1];
            }
            if (nArray4 != null) {
                polyVertex4.texCoordIndex = nArray4[n5 + n2 - 1];
            }
            if (!EarCutTriangulator.isConvexVertex(fArray, nArray[n + n2 - 2] * 3, nArray[n + n2 - 1] * 3, nArray[n] * 3, this.faceNormal)) {
                this.concaveVertices.add((Object)polyVertex4);
            }
            polyVertex.prev = polyVertex4;
            polyVertex4.next = polyVertex;
            polyVertex4.prev = polyVertex2;
            polyVertex2.next = polyVertex4;
        }
        return this.triangulate(polyVertex, nArray5, nArray6, nArray7, nArray8);
    }

    public int triangulateConcavePolygon(float[] fArray, int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, float[] fArray2) {
        if (n2 < 3) {
            return 0;
        }
        if (n2 == 3) {
            nArray[0] = n;
            nArray[1] = n + 3;
            nArray[2] = n + 6;
            if (nArray2 != null) {
                nArray2[0] = n3;
                nArray2[1] = n3 + 3;
                nArray2[2] = n3 + 6;
            }
            if (nArray3 != null) {
                nArray3[0] = n4;
                nArray3[1] = n4 + 3;
                nArray3[2] = n4 + 6;
            }
            if (nArray4 != null) {
                nArray4[0] = n5;
                nArray4[1] = n5 + 3;
                nArray4[2] = n5 + 6;
            }
            return 1;
        }
        this.faceNormal[0] = fArray2[0];
        this.faceNormal[1] = fArray2[1];
        this.faceNormal[2] = fArray2[2];
        if (n2 > this.tmpArray.length) {
            this.tmpArray = new PolyVertex[n2];
        }
        PolyVertex polyVertex = EarCutTriangulator.newVertex();
        polyVertex.x = fArray[n];
        polyVertex.y = fArray[n + 1];
        polyVertex.z = fArray[n + 2];
        polyVertex.vertexIndex = n;
        polyVertex.colorIndex = n4;
        polyVertex.normalIndex = n3;
        polyVertex.texCoordIndex = n5;
        if (!EarCutTriangulator.isConvexVertex(fArray, n + (n2 - 1) * 3, n, n + 3, this.faceNormal)) {
            this.concaveVertices.add((Object)polyVertex);
        }
        PolyVertex polyVertex2 = polyVertex;
        PolyVertex polyVertex3 = polyVertex;
        int n6 = n + 3;
        int n7 = 3;
        for (int i = 1; i < n2 - 1; ++i) {
            polyVertex2 = EarCutTriangulator.newVertex();
            polyVertex2.x = fArray[n6];
            polyVertex2.y = fArray[n6 + 1];
            polyVertex2.z = fArray[n6 + 2];
            polyVertex2.vertexIndex = n6;
            polyVertex2.colorIndex = n4 + n7;
            polyVertex2.normalIndex = n3 + n7;
            polyVertex2.texCoordIndex = n5 + n7;
            if (!EarCutTriangulator.isConvexVertex(fArray, n6 - 3, n6, n6 + 3, this.faceNormal)) {
                this.concaveVertices.add((Object)polyVertex2);
            }
            polyVertex2.prev = polyVertex3;
            polyVertex3.next = polyVertex2;
            polyVertex3 = polyVertex2;
            n6 += 3;
            n7 += 3;
        }
        if (fArray[n6] == fArray[n] && fArray[n6 + 1] == fArray[n + 1] && fArray[n6 + 2] == fArray[n + 2]) {
            polyVertex2.next = polyVertex;
            polyVertex.prev = polyVertex2;
        } else {
            PolyVertex polyVertex4 = EarCutTriangulator.newVertex();
            polyVertex4.x = fArray[n6];
            polyVertex4.y = fArray[n6 + 1];
            polyVertex4.z = fArray[n6 + 2];
            polyVertex4.vertexIndex = n6;
            polyVertex4.colorIndex = n4 + n7;
            polyVertex4.normalIndex = n3 + n7;
            polyVertex4.texCoordIndex = n5 + n7;
            if (!EarCutTriangulator.isConvexVertex(fArray, n6 - 3, n6, n, this.faceNormal)) {
                this.concaveVertices.add((Object)polyVertex4);
            }
            polyVertex.prev = polyVertex4;
            polyVertex4.next = polyVertex;
            polyVertex4.prev = polyVertex2;
            polyVertex2.next = polyVertex4;
        }
        return this.triangulate(polyVertex, nArray, nArray2, nArray3, nArray4);
    }

    public void clearCachedObjects() {
        vertexCache.clear();
    }

    private int triangulate(PolyVertex polyVertex, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length / 3;
        n3 *= n3;
        PolyVertex polyVertex2 = polyVertex.next.next;
        while (polyVertex2 != polyVertex) {
            PolyVertex polyVertex3 = polyVertex2.prev;
            boolean bl = false;
            if (++n2 > n3) {
                System.out.println("Endless loop in Triangulation detected");
                System.out.println("Possible causes: ");
                System.out.println("  The normals are not correct");
                System.out.println("  Non-planar polygons");
                System.out.println("  Self-intersecting polygons");
                System.out.println("  Degenerate polygons with all coincident vertices");
                this.concaveVertices.clear();
                return -n / 3;
            }
            bl = this.isTriangle(polyVertex2);
            if (this.isEar(polyVertex3) && !bl) {
                if (this.isCoincident(polyVertex3)) {
                    polyVertex3.prev.next = polyVertex2;
                    polyVertex2.prev = polyVertex3.prev;
                    if (polyVertex3 == polyVertex) {
                        polyVertex2 = polyVertex2.next;
                    }
                    polyVertex3.next = null;
                    polyVertex3.prev = null;
                    EarCutTriangulator.freeVertex(polyVertex3);
                    continue;
                }
                nArray[n] = polyVertex2.prev.prev.vertexIndex;
                nArray[n + 1] = polyVertex2.prev.vertexIndex;
                nArray[n + 2] = polyVertex2.vertexIndex;
                if (nArray2 != null) {
                    nArray2[n] = polyVertex2.prev.prev.normalIndex;
                    nArray2[n + 1] = polyVertex2.prev.normalIndex;
                    nArray2[n + 2] = polyVertex2.normalIndex;
                }
                if (nArray3 != null) {
                    nArray3[n] = polyVertex2.prev.prev.colorIndex;
                    nArray3[n + 1] = polyVertex2.prev.colorIndex;
                    nArray3[n + 2] = polyVertex2.colorIndex;
                }
                if (nArray4 != null) {
                    nArray4[n] = polyVertex2.prev.prev.texCoordIndex;
                    nArray4[n + 1] = polyVertex2.prev.texCoordIndex;
                    nArray4[n + 2] = polyVertex2.texCoordIndex;
                }
                n += 3;
                polyVertex3.prev.next = polyVertex2;
                polyVertex2.prev = polyVertex3.prev;
                if (this.concaveVertices.contains((Object)polyVertex2) && this.isConvexVertex(polyVertex2.prev, polyVertex2, polyVertex2.next)) {
                    this.concaveVertices.remove((Object)polyVertex2);
                }
                if (this.concaveVertices.contains((Object)polyVertex3) && this.isConvexVertex(polyVertex3.prev, polyVertex3, polyVertex3.next)) {
                    this.concaveVertices.remove((Object)polyVertex2);
                }
                if (polyVertex3 == polyVertex) {
                    polyVertex2 = polyVertex2.next;
                }
                polyVertex3.next = null;
                polyVertex3.prev = null;
                EarCutTriangulator.freeVertex(polyVertex3);
                continue;
            }
            if (bl) {
                nArray[n] = polyVertex2.prev.prev.vertexIndex;
                nArray[n + 1] = polyVertex2.prev.vertexIndex;
                nArray[n + 2] = polyVertex2.vertexIndex;
                if (nArray2 != null) {
                    nArray2[n] = polyVertex2.prev.prev.normalIndex;
                    nArray2[n + 1] = polyVertex2.prev.normalIndex;
                    nArray2[n + 2] = polyVertex2.normalIndex;
                }
                if (nArray3 != null) {
                    nArray3[n] = polyVertex2.prev.prev.colorIndex;
                    nArray3[n + 1] = polyVertex2.prev.colorIndex;
                    nArray3[n + 2] = polyVertex2.colorIndex;
                }
                if (nArray4 != null) {
                    nArray4[n] = polyVertex2.prev.prev.texCoordIndex;
                    nArray4[n + 1] = polyVertex2.prev.texCoordIndex;
                    nArray4[n + 2] = polyVertex2.texCoordIndex;
                }
                n += 3;
                PolyVertex polyVertex4 = polyVertex2.next;
                if (polyVertex4.next != polyVertex2) {
                    PolyVertex polyVertex5 = polyVertex4.next;
                    polyVertex5.next = null;
                    polyVertex5.prev = null;
                    EarCutTriangulator.freeVertex(polyVertex5);
                }
                polyVertex4.next = null;
                polyVertex4.prev = null;
                EarCutTriangulator.freeVertex(polyVertex4);
                polyVertex2.next = null;
                polyVertex2.prev = null;
                EarCutTriangulator.freeVertex(polyVertex2);
                polyVertex2 = null;
                break;
            }
            polyVertex2 = polyVertex2.next;
        }
        this.concaveVertices.clear();
        return n / 3;
    }

    private boolean isEar(PolyVertex polyVertex) {
        int n = this.concaveVertices.size();
        if (n == 0) {
            return true;
        }
        if (this.isConvexVertex(polyVertex.prev, polyVertex, polyVertex.next)) {
            this.tmpArray = (PolyVertex[])this.concaveVertices.toArray((Object[])this.tmpArray);
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                PolyVertex polyVertex2 = this.tmpArray[i];
                if (polyVertex2 == polyVertex || polyVertex2 == polyVertex.prev || polyVertex2 == polyVertex.next || !this.isPointInTriangle(polyVertex2, polyVertex.prev, polyVertex, polyVertex.next) || polyVertex2.x == polyVertex.x && polyVertex2.y == polyVertex.y && polyVertex2.z == polyVertex.z || polyVertex2.x == polyVertex.prev.x && polyVertex2.y == polyVertex.prev.y && polyVertex2.z == polyVertex.prev.z || polyVertex2.x == polyVertex.next.x && polyVertex2.y == polyVertex.next.y && polyVertex2.z == polyVertex.next.z) continue;
                bl = true;
                break;
            }
            return !bl;
        }
        return false;
    }

    private boolean isTriangle(PolyVertex polyVertex) {
        return polyVertex.next == polyVertex || polyVertex.next.next == polyVertex || polyVertex.next.next.next == polyVertex;
    }

    private boolean isConvexVertex(PolyVertex polyVertex, PolyVertex polyVertex2, PolyVertex polyVertex3) {
        float f = polyVertex2.y - polyVertex.y;
        float f2 = polyVertex3.z - polyVertex2.z;
        float f3 = polyVertex2.z - polyVertex.z;
        float f4 = polyVertex3.y - polyVertex2.y;
        float f5 = f * f2 - f3 * f4;
        float f6 = polyVertex3.x - polyVertex2.x;
        float f7 = polyVertex2.x - polyVertex.x;
        float f8 = f3 * f6 - f7 * f2;
        float f9 = f7 * f4 - f * f6;
        float f10 = f5 * this.faceNormal[0] + f8 * this.faceNormal[1] + f9 * this.faceNormal[2];
        return f10 >= 0.0f;
    }

    private static boolean isConvexVertex(float[] fArray, int n, int n2, int n3, float[] fArray2) {
        float f = fArray[n2 + 1] - fArray[n + 1];
        float f2 = fArray[n3 + 2] - fArray[n2 + 2];
        float f3 = fArray[n2 + 2] - fArray[n + 2];
        float f4 = fArray[n3 + 1] - fArray[n2 + 1];
        float f5 = f * f2 - f3 * f4;
        float f6 = fArray[n3] - fArray[n2];
        float f7 = fArray[n2] - fArray[n];
        float f8 = f3 * f6 - f7 * f2;
        float f9 = f7 * f4 - f * f6;
        float f10 = f5 * fArray2[0] + f8 * fArray2[1] + f9 * fArray2[2];
        return f10 >= 0.0f;
    }

    private boolean isPointInTriangle(PolyVertex polyVertex, PolyVertex polyVertex2, PolyVertex polyVertex3, PolyVertex polyVertex4) {
        double d = this.faceNormal[0] >= 0.0f ? (double)this.faceNormal[0] : (double)(-this.faceNormal[0]);
        double d2 = this.faceNormal[1] >= 0.0f ? (double)this.faceNormal[1] : (double)(-this.faceNormal[1]);
        double d3 = this.faceNormal[2] >= 0.0f ? (double)this.faceNormal[2] : (double)(-this.faceNormal[2]);
        int n = d > d2 ? 0 : 1;
        if (n == 0) {
            if (d < d3) {
                n = 2;
            }
        } else if (d2 < d3) {
            n = 2;
        }
        switch (n) {
            case 0: {
                this.working2dCoords[5] = polyVertex4.z - polyVertex.z;
                this.working2dCoords[4] = polyVertex4.y - polyVertex.y;
                this.working2dCoords[3] = polyVertex3.z - polyVertex.z;
                this.working2dCoords[2] = polyVertex3.y - polyVertex.y;
                this.working2dCoords[1] = polyVertex2.z - polyVertex.z;
                this.working2dCoords[0] = polyVertex2.y - polyVertex.y;
                break;
            }
            case 1: {
                this.working2dCoords[5] = polyVertex4.z - polyVertex.z;
                this.working2dCoords[4] = polyVertex4.x - polyVertex.x;
                this.working2dCoords[3] = polyVertex3.z - polyVertex.z;
                this.working2dCoords[2] = polyVertex3.x - polyVertex.x;
                this.working2dCoords[1] = polyVertex2.z - polyVertex.z;
                this.working2dCoords[0] = polyVertex2.x - polyVertex.x;
                break;
            }
            case 2: {
                this.working2dCoords[5] = polyVertex4.y - polyVertex.y;
                this.working2dCoords[4] = polyVertex4.x - polyVertex.x;
                this.working2dCoords[3] = polyVertex3.y - polyVertex.y;
                this.working2dCoords[2] = polyVertex3.x - polyVertex.x;
                this.working2dCoords[1] = polyVertex2.y - polyVertex.y;
                this.working2dCoords[0] = polyVertex2.x - polyVertex.x;
            }
        }
        int n2 = 0;
        int n3 = (double)this.working2dCoords[1] < 0.0 ? -1 : 1;
        for (int i = 0; i < 3; ++i) {
            float f;
            int n4 = (i + 1) % 3;
            int n5 = i * 2;
            int n6 = n4 * 2;
            int n7 = i * 2 + 1;
            int n8 = n4 * 2 + 1;
            int n9 = (double)this.working2dCoords[n8] < 0.0 ? -1 : 1;
            if (n3 == n9) continue;
            if ((double)this.working2dCoords[n5] > 0.0 && (double)this.working2dCoords[n6] > 0.0) {
                ++n2;
            } else if (((double)this.working2dCoords[n5] > 0.0 || (double)this.working2dCoords[n6] > 0.0) && (f = this.working2dCoords[n5] - this.working2dCoords[n7] * (this.working2dCoords[n6] - this.working2dCoords[n5]) / (this.working2dCoords[n8] - this.working2dCoords[n7])) > 0.0f) {
                ++n2;
            }
            n3 = n9;
        }
        return n2 % 2 == 1;
    }

    private boolean isCoincident(PolyVertex polyVertex) {
        float f = polyVertex.x - polyVertex.prev.x;
        float f2 = polyVertex.y - polyVertex.prev.y;
        float f3 = polyVertex.z - polyVertex.prev.z;
        float f4 = polyVertex.x - polyVertex.next.x;
        float f5 = polyVertex.y - polyVertex.next.y;
        float f6 = polyVertex.z - polyVertex.next.z;
        float f7 = f2 * f6 - f3 * f5;
        float f8 = f3 * f4 - f * f6;
        float f9 = f * f5 - f2 * f4;
        return f7 == 0.0f && f8 == 0.0f && f9 == 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PolyVertex newVertex() {
        PolyVertex polyVertex = null;
        ObjectArray objectArray = vertexCache;
        synchronized (objectArray) {
            polyVertex = vertexCache.size() == 0 ? new PolyVertex() : (PolyVertex)vertexCache.remove(0);
        }
        return polyVertex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void freeVertex(PolyVertex polyVertex) {
        ObjectArray objectArray = vertexCache;
        synchronized (objectArray) {
            vertexCache.add((Object)polyVertex);
        }
    }
}

