/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.navigation.PathNotConstructable;
import cz.cuni.amis.pogamut.base.agent.navigation.PathPlannerListener;
import cz.cuni.amis.pogamut.base.agent.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldEventListener;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.objects.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTAstar;
import cz.cuni.amis.pogamut.ut2004.agent.worldview.UT2004SyncLockableWorldView;
import cz.cuni.amis.pogamut.ut2004.bot.SyncUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Jump;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.MapPointListObtained;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AgentScoped
public class SimpleBot
extends SyncUT2004Bot<UT2004SyncLockableWorldView> {
    public ArrayList<ILocated> myPath = new ArrayList();
    public boolean pathRequested = false;
    public boolean pathReceived = false;
    public HashMap<UnrealId, NavPoint> knownNavPoints = new HashMap();
    public NavPoint myNavTarget;
    public double currentTime = 0.0;
    public double lastMovementTime = 0.0;
    public Game game;
    public AgentInfo agentInfo;
    public Players players;
    public UTAstar myPathPlanner;
    public WorldEventListener myMapListObtainedListener = new WorldEventListener(){

        public void notify(Object event) {
            MapPointListObtained map = (MapPointListObtained)event;
            SimpleBot.this.knownNavPoints.putAll(map.getNavPoints());
        }
    };
    public WorldEventListener myBegListener = new WorldEventListener(){

        public void notify(Object event) {
            if (event instanceof BeginMessage) {
                BeginMessage bm = (BeginMessage)event;
                SimpleBot.this.currentTime = bm.getTime();
            }
        }
    };
    public PathPlannerListener myPathListener = new PathPlannerListener(){

        public void pathEvent(List path) {
            SimpleBot.this.myPath = (ArrayList)path;
            SimpleBot.this.pathReceived = true;
        }
    };

    @Inject
    public SimpleBot(AgentLogger logger, UT2004SyncLockableWorldView worldView, ICommandSerializer commandSerializer) {
        super(logger, worldView, commandSerializer);
    }

    @Override
    protected void prePrepareBot() {
        this.getLogger().setLevel(Level.WARNING);
        ((UT2004SyncLockableWorldView)this.getWorldView()).addListener(MapPointListObtained.class, this.myMapListObtainedListener);
        ((UT2004SyncLockableWorldView)this.getWorldView()).addListener(BeginMessage.class, this.myBegListener);
        this.game = new Game((IWorldView)this.getWorldView(), this.getLogger().user());
        this.agentInfo = new AgentInfo((IWorldView)this.getWorldView(), this.game, this.getLogger().user());
        this.players = new Players((IWorldView)this.getWorldView(), this.agentInfo, this.getLogger().user());
        this.myPathPlanner = new UTAstar(this.getAct(), (IWorldView)this.getWorldView());
    }

    @Override
    protected void postPrepareBot(GameInfo info) {
    }

    @Override
    protected Initialize createInitializeCommand() {
        Initialize myInit = new Initialize();
        myInit.setName("SimpleBot007");
        return myInit;
    }

    @Override
    protected void botInitialized(ConfigChange config, InitedMessage init) {
        this.getAct().act(new SendMessage().setText("I am alive!"));
    }

    @Override
    protected void doLogic() throws PogamutException {
        if (this.agentInfo.getVelocity().size() > 10.0) {
            this.lastMovementTime = this.currentTime;
        }
        if (this.myNavTarget == null) {
            this.myPath.clear();
            this.pathRequested = false;
            this.pathReceived = false;
            this.myNavTarget = this.pickNewRandomNavTarget();
        }
        if (this.myNavTarget != null) {
            if (this.myNavTarget.getLocation().getDistance(this.agentInfo.getLocation()) < 80.0) {
                this.myNavTarget = null;
            } else {
                this.goToLocation(this.myNavTarget.getLocation());
            }
        }
        if (this.currentTime - this.lastMovementTime > 3.0) {
            this.getAct().act(new Jump());
            this.myNavTarget = null;
        }
    }

    @Override
    protected void botKilled(BotKilled event) {
        this.myPath.clear();
        this.pathReceived = false;
        this.pathRequested = false;
        this.myNavTarget = null;
    }

    private boolean goToLocation(Location targetLocation) {
        Iterator<ILocated> it;
        if (this.agentInfo.atLocation(targetLocation, 100.0)) {
            this.myPath.clear();
            this.pathReceived = false;
            this.pathRequested = false;
            return false;
        }
        if (this.myPath.isEmpty() && !this.pathRequested) {
            try {
                this.myPathPlanner.addPathListener(this.myPathListener);
                this.myPathPlanner.computePath(this.agentInfo.getLocation(), targetLocation);
                this.pathRequested = true;
                return true;
            }
            catch (PathNotConstructable ex) {
                Logger.getLogger(SimpleBot.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        if (this.pathRequested && !this.pathReceived) {
            return true;
        }
        if (this.myPath.isEmpty() && this.pathReceived) {
            this.myPath.add(targetLocation);
        }
        if (this.myPath.get(0).getLocation().getDistance(this.agentInfo.getLocation()) < 40.0) {
            this.myPath.remove(0);
        }
        if ((it = this.myPath.iterator()).hasNext()) {
            Location l1 = it.next().getLocation();
            if (it.hasNext()) {
                Location l2 = it.next().getLocation();
                this.getAct().act(new Move().setFirstLocation(l1).setSecondLocation(l2));
                return true;
            }
            this.getAct().act(new Move().setFirstLocation(l1));
            return true;
        }
        return false;
    }

    private NavPoint pickNewRandomNavTarget() {
        Random rand = new Random();
        int counter = rand.nextInt(this.knownNavPoints.values().size());
        int i = 0;
        for (NavPoint nav : this.knownNavPoints.values()) {
            if (i == counter) {
                return nav;
            }
            ++i;
        }
        return null;
    }
}

