/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.future;

import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FlagFuture<Result, FlagType>
implements Future<Result>,
FlagListener<FlagType> {
    private Map<FlagType, Result> terminalMap;
    private Flag<FlagType> waitFlag;
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean done = false;
    private Result result = null;

    public FlagFuture(Flag<FlagType> waitFlag, Map<FlagType, Result> terminalMap) {
        this.terminalMap = new HashMap<FlagType, Result>(terminalMap);
        this.waitFlag = waitFlag;
        this.init();
    }

    public FlagFuture(Flag<FlagType> waitFlag, FlagType terminalFlagValue, Result resultValue) {
        this.terminalMap = new HashMap<FlagType, Result>();
        this.terminalMap.put(terminalFlagValue, resultValue);
        this.waitFlag = waitFlag;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.waitFlag.addListener(this);
        CountDownLatch countDownLatch = this.latch;
        synchronized (countDownLatch) {
            FlagType value;
            if (!this.done && this.terminalMap.containsKey(value = this.waitFlag.getFlag())) {
                this.result = this.terminalMap.get(value);
                this.done = true;
                this.latch.countDown();
            }
        }
        if (this.done) {
            this.waitFlag.removeListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Result result) {
        CountDownLatch countDownLatch = this.latch;
        synchronized (countDownLatch) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.result = result;
        }
        this.waitFlag.removeListener(this);
        this.latch.countDown();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public Result get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.result;
    }

    @Override
    public Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.latch.await(timeout, unit);
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flagChanged(FlagType changedValue) {
        CountDownLatch countDownLatch = this.latch;
        synchronized (countDownLatch) {
            if (this.done) {
                this.waitFlag.removeListener(this);
                return;
            }
            if (this.terminalMap.containsKey(changedValue)) {
                this.result = this.terminalMap.get(changedValue);
                this.done = true;
                this.waitFlag.removeListener(this);
                this.latch.countDown();
            }
        }
    }
}

