/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.flag.jmx;

import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.flag.jmx.FlagChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;

public class JMXFlagDecorator<T> {
    protected Flag<T> flag = null;
    protected NotificationBroadcasterSupport nbs = null;
    protected Object source;
    protected int eventCounter = 0;
    protected FlagListener<T> listener = new FlagListener<T>(){

        @Override
        public void flagChanged(T changedValue) {
            JMXFlagDecorator.this.nbs.sendNotification(new FlagChangeNotification(JMXFlagDecorator.this, changedValue));
        }
    };

    public JMXFlagDecorator(Flag<T> flag, Object source, NotificationBroadcasterSupport nbs) {
        this.flag = flag;
        this.nbs = nbs;
        this.source = source;
        flag.addListener(this.listener);
    }

    public void stop() {
        this.flag.removeListener(this.listener);
    }

    public MBeanNotificationInfo getMBeanNotificationInfo() {
        return new MBeanNotificationInfo(new String[]{"cz.cuni.amis.utils.flag.change"}, FlagChangeNotification.class.getName(), "The flag has changed it's value.");
    }
}

