/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.flag;

import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class WaitForFlagChange<TYPE> {
    private IAccept<TYPE> accept;
    private Flag<TYPE> flag;
    private Object latchAccessMutex = new Object();
    private Object mutex = new Object();
    private CountDownLatch latch = null;
    private boolean isResult = false;
    private TYPE result = null;

    public WaitForFlagChange(Flag<TYPE> flag, IAccept<TYPE> waitingFor) {
        this.flag = flag;
        this.accept = waitingFor;
    }

    public WaitForFlagChange(Flag<TYPE> flag, TYPE waitingFor) {
        this.flag = flag;
        this.accept = new ListAccept(waitingFor);
    }

    public WaitForFlagChange(Flag<TYPE> flag, TYPE[] waitingFor) {
        this.flag = flag;
        this.accept = new ListAccept(waitingFor);
    }

    public WaitForFlagChange(Flag<TYPE> flag, Collection<TYPE> waitingFor) {
        this.flag = flag;
        this.accept = new ListAccept(waitingFor);
    }

    private boolean isDesiredValue(TYPE value) {
        return this.accept.accept(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TYPE await() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            Object object2 = this.latchAccessMutex;
            synchronized (object2) {
                this.latch = new CountDownLatch(1);
            }
            Listener listener = new Listener(this.flag);
            if (this.isResult) {
                return this.result;
            }
            this.latch.await();
            Object object3 = this.latchAccessMutex;
            synchronized (object3) {
                this.flag.removeListener(listener);
                this.latch = null;
            }
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TYPE await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            Object object2 = this.latchAccessMutex;
            synchronized (object2) {
                this.latch = new CountDownLatch(1);
            }
            Listener listener = new Listener(this.flag);
            if (this.isResult) {
                return this.result;
            }
            this.latch.await(timeout, timeUnit);
            Object object3 = this.latchAccessMutex;
            synchronized (object3) {
                this.flag.removeListener(listener);
                this.latch = null;
            }
            return this.result;
        }
    }

    private class Listener
    implements FlagListener<TYPE> {
        public Listener(Flag<TYPE> flag) {
            Object result;
            WaitForFlagChange.this.result = flag.getFlag();
            if (!(WaitForFlagChange.this.isResult = WaitForFlagChange.this.isDesiredValue(WaitForFlagChange.this.result))) {
                flag.addListener(this);
            }
            if (!WaitForFlagChange.this.isResult && WaitForFlagChange.this.isDesiredValue(result = flag.getFlag())) {
                flag.removeListener(this);
                WaitForFlagChange.this.isResult = true;
                WaitForFlagChange.this.result = result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flagChanged(TYPE changedValue) {
            if (!WaitForFlagChange.this.isResult && WaitForFlagChange.this.isDesiredValue(changedValue)) {
                WaitForFlagChange.this.flag.removeListener(this);
                Object object = WaitForFlagChange.this.latchAccessMutex;
                synchronized (object) {
                    if (WaitForFlagChange.this.latch != null) {
                        WaitForFlagChange.this.latch.countDown();
                    }
                }
                WaitForFlagChange.this.isResult = true;
                WaitForFlagChange.this.result = changedValue;
            }
        }
    }

    private class ListAccept
    implements IAccept<TYPE> {
        private List<TYPE> waitingFor;

        public ListAccept(Collection<TYPE> list) {
            this.waitingFor = new ArrayList(list.size());
            this.waitingFor.addAll(list);
        }

        public ListAccept(TYPE ... accept) {
            this.waitingFor = new ArrayList(accept.length);
            this.waitingFor.addAll(MyCollections.asList(accept));
        }

        @Override
        public boolean accept(TYPE flagValue) {
            return this.waitingFor.contains(flagValue);
        }
    }

    public static interface IAccept<TYPE> {
        public boolean accept(TYPE var1);
    }
}

