/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.collections;

import cz.cuni.amis.utils.collections.CollectionEventListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ObservableCollection<E>
implements Collection<E> {
    protected Collection<E> col = null;
    protected List<CollectionEventListener<E>> eventListeners = new ArrayList<CollectionEventListener<E>>();

    public void addCollectionListener(CollectionEventListener listener) {
        this.eventListeners.add(listener);
    }

    public boolean removeCollectionListener(CollectionEventListener listener) {
        return this.eventListeners.remove(listener);
    }

    public ObservableCollection(Collection c) {
        this.col = c;
    }

    @Override
    public int size() {
        return this.col.size();
    }

    @Override
    public boolean isEmpty() {
        return this.col.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.col.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.col.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.col.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.col.toArray(a);
    }

    @Override
    public boolean add(E e) {
        List<E> add = Collections.singletonList(e);
        this.notifyPreAdd(add);
        boolean ret = this.col.add(e);
        this.notifyPostAdd(add);
        return ret;
    }

    @Override
    public boolean remove(Object o) {
        List<Object> rem = Collections.singletonList(o);
        this.notifyPreRemove(rem);
        boolean ret = this.col.remove(o);
        this.notifyPostRemove(rem);
        return ret;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.col.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.notifyPreAdd(c);
        boolean ret = this.col.addAll(c);
        this.notifyPostAdd(c);
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.notifyPreRemove(c);
        boolean ret = this.col.removeAll(c);
        this.notifyPostRemove(c);
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.col.retainAll(c);
    }

    @Override
    public void clear() {
        this.notifyPreRemove(this.col);
        this.col.clear();
        this.notifyPostRemove(this.col);
    }

    protected void notifyPreAdd(Collection<? extends E> add) {
        for (CollectionEventListener<? extends E> collectionEventListener : this.eventListeners) {
            collectionEventListener.preAddEvent(add, this);
        }
    }

    protected void notifyPostAdd(Collection<? extends E> add) {
        for (CollectionEventListener<? extends E> collectionEventListener : this.eventListeners) {
            collectionEventListener.postAddEvent(add, this);
        }
    }

    protected void notifyPreRemove(Collection<?> remove) {
        for (CollectionEventListener<?> collectionEventListener : this.eventListeners) {
            collectionEventListener.preRemoveEvent(remove, this);
        }
    }

    protected void notifyPostRemove(Collection<?> remove) {
        for (CollectionEventListener<?> collectionEventListener : this.eventListeners) {
            collectionEventListener.postRemoveEvent(remove, this);
        }
    }
}

