/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ClassUtils {
    private static Map<Class, SoftReference<Collection<Class>>> subclassesCache = new HashMap<Class, SoftReference<Collection<Class>>>();

    private static void probeInterface(Class interf, Collection<Class> interfaces) {
        interfaces.add(interf);
        for (int i = 0; i < interf.getInterfaces().length; ++i) {
            ClassUtils.probeInterface(interf.getInterfaces()[i], interfaces);
        }
    }

    public static synchronized Collection<Class> getSubclasses(Class cls) {
        SoftReference<Collection<Class>> reference = subclassesCache.get(cls);
        Collection<Class> classes = null;
        if (reference != null) {
            classes = reference.get();
        }
        if (classes != null) {
            return classes;
        }
        classes = new HashSet<Class>();
        classes.add(cls);
        if (cls.getInterfaces() != null) {
            for (int i = 0; i < cls.getInterfaces().length; ++i) {
                ClassUtils.probeInterface(cls.getInterfaces()[i], classes);
            }
        }
        for (Class superClass = cls.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            classes.add(superClass);
            if (superClass.getInterfaces() == null) continue;
            for (int i = 0; i < superClass.getInterfaces().length; ++i) {
                ClassUtils.probeInterface(superClass.getInterfaces()[i], classes);
            }
        }
        classes.remove(Object.class);
        subclassesCache.put(cls, new SoftReference<Collection<Class>>(classes));
        return classes;
    }
}

