/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base3d.worldview.objects;

import cz.cuni.amis.pogamut.base3d.worldview.objects.IRotable;
import javax.vecmath.Point3d;

public class Rotation
implements IRotable {
    public double yaw = 0.0;
    public double roll = 0.0;
    public double pitch = 0.0;

    public double getYaw() {
        return this.yaw;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getRoll() {
        return this.roll;
    }

    @Override
    public Rotation getRotation() {
        return this;
    }

    public Point3d getPoint3d() {
        return new Point3d(this.pitch, this.yaw, this.roll);
    }

    public Rotation() {
    }

    public Rotation(double yaw, double roll, double pitch) {
        this.yaw = yaw;
        this.roll = roll;
        this.pitch = pitch;
    }

    public static final double LinearInterp(double a, double b, double alpha) {
        return a + (b - a) * alpha;
    }

    public static final double LogInterp(double a, double b, double alpha) {
        return a + (b - a) * Math.log(1.0 + alpha * 1.718281828459045);
    }

    public static final double ExpInterp(double a, double b, double alpha) {
        return a + (b - a) * (Math.exp(alpha) - 1.0) / 1.718281828459045;
    }

    public static final Rotation RotationLinearInterp(Rotation a, Rotation b, double alpha) {
        return new Rotation(Rotation.LinearInterp(a.yaw, b.yaw, alpha), Rotation.LinearInterp(a.roll, b.roll, alpha), Rotation.LinearInterp(a.pitch, b.pitch, alpha));
    }

    public final Rotation RotationLinearInterp(Rotation b, double alpha) {
        return Rotation.RotationLinearInterp(this, b, alpha);
    }

    public final Rotation RotationLogInterp(Rotation b, double alpha) {
        return Rotation.RotationLogInterp(this, b, alpha);
    }

    public static final Rotation RotationLogInterp(Rotation a, Rotation b, double alpha) {
        return new Rotation(Rotation.LogInterp(a.yaw, b.yaw, alpha), Rotation.LogInterp(a.roll, b.roll, alpha), Rotation.LogInterp(a.pitch, b.pitch, alpha));
    }

    public final Rotation RotationExpInterp(Rotation b, double alpha) {
        return Rotation.RotationExpInterp(this, b, alpha);
    }

    public static final Rotation RotationExpInterp(Rotation a, Rotation b, double alpha) {
        return new Rotation(Rotation.ExpInterp(a.yaw, b.yaw, alpha), Rotation.ExpInterp(a.roll, b.roll, alpha), Rotation.ExpInterp(a.pitch, b.pitch, alpha));
    }

    public String toString() {
        return String.format("[%.2f, %.2f, %.2f]", this.yaw, this.roll, this.pitch);
    }
}

