/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base3d.worldview;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldEventListener;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.IWorldObject;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.IWorldObjectId;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.objects.IViewable;
import cz.cuni.amis.utils.ClassUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AgentScoped
public class Vision
implements WorldEventListener<IWorldObjectEvent> {
    private Map seeObjects = Collections.synchronizedMap(new HashMap());
    private Map immutableSeeObjects = Collections.unmodifiableMap(this.seeObjects);
    private Map<IWorldObjectId, IWorldObject> seeObjectsId = Collections.synchronizedMap(new HashMap());

    @Inject
    public Vision(IWorldView worldView, AgentLogger logger) {
        worldView.addListener(IViewable.class, IWorldObjectEvent.class, (WorldEventListener<? extends IWorldObjectEvent>)this);
    }

    @Override
    public void notify(IWorldObjectEvent event) {
        IWorldObject obj = this.seeObjectsId.get(event.getId());
        if (obj != null) {
            if (((IViewable)obj).isVisible()) {
                if (this.seeObjects.get(event.getId()) == null) {
                    this.addSeeObject(obj);
                }
            } else if (this.seeObjects.get(event.getId()) != null) {
                this.removeSeeObject(obj);
            }
        } else {
            IViewable object = (IViewable)event.getObject();
            if (object.isVisible()) {
                if (this.seeObjects.get(event.getId()) == null) {
                    this.addSeeObject(obj);
                }
            } else if (this.seeObjects.get(event.getId()) != null) {
                this.removeSeeObject(obj);
            }
        }
    }

    protected synchronized <T> Map<IWorldObjectId, T> addNewObjectCategory(Class<T> cls) {
        Map objects = Collections.synchronizedMap(new HashMap());
        this.seeObjects.put(cls, objects);
        this.immutableSeeObjects.put(cls, Collections.unmodifiableMap(objects));
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSeeObject(IWorldObject seeObject) {
        this.seeObjectsId.put(seeObject.getId(), seeObject);
        for (Class cls : ClassUtils.getSubclasses(seeObject.getClass())) {
            Map objects;
            Map map = this.seeObjects;
            synchronized (map) {
                objects = (Map)this.seeObjects.get(cls);
                if (objects == null) {
                    objects = this.addNewObjectCategory(cls);
                }
            }
            objects.put(seeObject.getId(), seeObject);
        }
    }

    protected IWorldObject getSeeObject(IWorldObjectId objectId) {
        return this.seeObjectsId.get(objectId);
    }

    protected void removeSeeObject(IWorldObject worldObject) {
        this.seeObjectsId.remove(worldObject.getId());
        for (Class cls : ClassUtils.getSubclasses(worldObject.getClass())) {
            Map objects = (Map)this.seeObjects.get(cls);
            if (objects == null) continue;
            objects.remove(worldObject.getId());
        }
    }

    public Map<Class, Map<IWorldObjectId, IWorldObject>> getSee() {
        return this.immutableSeeObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Map<IWorldObjectId, T> getSee(Class<T> type) {
        Map map = this.seeObjects;
        synchronized (map) {
            Map objects = (Map)this.immutableSeeObjects.get(type);
            if (objects == null) {
                this.addNewObjectCategory(type);
                return (Map)this.immutableSeeObjects.get(type);
            }
            return objects;
        }
    }

    public IWorldObject getSee(IWorldObjectId id) {
        return this.seeObjectsId.get(id);
    }
}

