/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogFormatter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public abstract class LogPublisher
implements ILogPublisher {
    protected Formatter formatter = null;

    public LogPublisher() {
        this.formatter = new LogFormatter();
    }

    public LogPublisher(Formatter formatter) {
        this.formatter = formatter;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public abstract void close() throws SecurityException;

    @Override
    public abstract void flush();

    public abstract void publish(String var1);

    @Override
    public void publish(LogRecord record) {
        Formatter actualFormatter = this.formatter;
        if (actualFormatter != null) {
            this.publish(actualFormatter.format(record));
        }
    }

    public static class FilePublisher
    extends LogPublisher {
        protected File file;
        protected FileOutputStream fileOut;
        protected PrintWriter fileWriter;

        public FilePublisher(File file) throws IOException {
            this.file = file;
            this.fileOut = new FileOutputStream(file);
            this.fileWriter = new PrintWriter(this.fileOut);
        }

        public FilePublisher(File file, Formatter formatter) {
            super(formatter);
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public void close() throws SecurityException {
            this.fileWriter.close();
            try {
                this.fileOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void flush() {
            this.fileWriter.flush();
            try {
                this.fileOut.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void publish(String formattedMsg) {
            this.fileWriter.println(formattedMsg);
        }
    }

    public static class ConsolePublisher
    extends LogPublisher {
        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(String formattedMsg) {
            System.out.println(formattedMsg);
        }
    }
}

