/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private SimpleDateFormat yearDateFormat = new SimpleDateFormat("y");
    private SimpleDateFormat monthDateFormat = new SimpleDateFormat("M");
    private SimpleDateFormat dayDateFormat = new SimpleDateFormat("d");
    private SimpleDateFormat timeFormat = new SimpleDateFormat("H:m:s.S");
    private StringBuffer buffer = new StringBuffer(512);

    @Override
    public String format(LogRecord record) {
        this.buffer.delete(0, this.buffer.length());
        Date date = new Date(record.getMillis());
        this.buffer.append(this.yearDateFormat.format(date));
        this.buffer.append("-");
        String month = this.monthDateFormat.format(date);
        if (month.length() > 1) {
            this.buffer.append(month);
        } else {
            this.buffer.append("0");
            this.buffer.append(month);
        }
        this.buffer.append("-");
        String day = this.dayDateFormat.format(date);
        if (day.length() > 1) {
            this.buffer.append(day);
        } else {
            this.buffer.append("0");
            this.buffer.append(day);
        }
        this.buffer.append(" ");
        this.buffer.append(this.timeFormat.format(date));
        this.buffer.append(" ");
        this.buffer.append(record.getLoggerName());
        this.buffer.append("\r\n");
        this.buffer.append(record.getLevel().toString());
        this.buffer.append(": ");
        this.buffer.append(record.getMessage());
        return this.buffer.toString();
    }
}

