/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategoryFilter;
import cz.cuni.amis.pogamut.base.utils.logging.LogHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogCategory
extends Logger {
    private String categoryName;

    public LogCategory(String categoryName) {
        super(categoryName, null);
        this.categoryName = categoryName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public LogHandler newHandler() {
        return this.newHandler(null);
    }

    public LogHandler newHandler(ILogPublisher publisher) {
        LogHandler handler = new LogHandler();
        handler.setFilter(new LogCategoryFilter(this));
        handler.setPublisher(publisher);
        this.addHandler(handler);
        return handler;
    }

    @Override
    public void log(Level level, String msg) {
        this.log(level, msg, new Object[0]);
    }

    @Override
    public void log(Level level, String msg, Object param) {
        this.log(level, msg, new Object[]{param});
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        if (params.length == 0) {
            super.log(level, msg, this);
        } else {
            Object[] finalParams = new Object[params.length + 1];
            finalParams[0] = this;
            System.arraycopy(params, 0, finalParams, 1, params.length);
            super.log(level, msg, finalParams);
        }
    }

    @Override
    public void finest(String msg) {
        this.log(Level.FINEST, msg);
    }

    public void finest(String msg, Object param) {
        this.log(Level.FINEST, msg, param);
    }

    public void finest(String msg, Object[] params) {
        this.log(Level.FINEST, msg, params);
    }

    @Override
    public void finer(String msg) {
        this.log(Level.FINER, msg);
    }

    public void finer(String msg, Object param) {
        this.log(Level.FINER, msg, param);
    }

    public void finer(String msg, Object[] params) {
        this.log(Level.FINER, msg, params);
    }

    @Override
    public void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    public void fine(String msg, Object param) {
        this.log(Level.FINE, msg, param);
    }

    public void fine(String msg, Object[] params) {
        this.log(Level.FINE, msg, params);
    }

    @Override
    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public void info(String msg, Object param) {
        this.log(Level.INFO, msg, param);
    }

    public void info(String msg, Object[] params) {
        this.log(Level.INFO, msg, params);
    }

    @Override
    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }

    public void warning(String msg, Object param) {
        this.log(Level.WARNING, msg, param);
    }

    public void warning(String msg, Object[] params) {
        this.log(Level.WARNING, msg, params);
    }

    @Override
    public void severe(String msg) {
        this.log(Level.SEVERE, msg);
    }

    public void severe(String msg, Object param) {
        this.log(Level.SEVERE, msg, param);
    }

    public void severe(String msg, Object[] params) {
        this.log(Level.SEVERE, msg, params);
    }

    public String toString() {
        return "LogCategory(" + this.getName() + ")";
    }
}

