/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import cz.cuni.amis.pogamut.base.utils.logging.ILogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class LogCategories
implements ILogCategories {
    private Map<String, LogCategory> categories = Collections.synchronizedMap(new HashMap());
    private Map<String, LogCategory> immutableCategories = Collections.unmodifiableMap(this.categories);
    private Comparator<String> stringComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null) {
                if (o1 == o2) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    };

    @Override
    public boolean hasCategory(String name) {
        return this.categories.containsKey(name);
    }

    @Override
    public Map<String, LogCategory> getCategories() {
        return this.immutableCategories;
    }

    @Override
    public String[] getCategoryNames() {
        return this.categories.keySet().toArray(new String[0]);
    }

    @Override
    public String[] getCategoryNamesSorted() {
        String[] names = this.getCategoryNames();
        Arrays.sort(names, this.stringComparator);
        return names;
    }

    @Override
    public LogCategory getCategory(String name) {
        LogCategory category = this.categories.get(name);
        if (category != null) {
            return category;
        }
        category = new LogCategory(name);
        this.categories.put(name, category);
        return category;
    }

    @Override
    public void setLevel(Level newLevel) {
        for (LogCategory category : this.categories.values()) {
            category.setLevel(newLevel);
        }
    }
}

