/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import cz.cuni.amis.pogamut.base.agent.exceptions.CantStartJMXException;
import cz.cuni.amis.pogamut.base.agent.exceptions.JMXAlreadyEnabledException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.IJMXEnabled;
import cz.cuni.amis.pogamut.base.utils.logging.ILogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.LogHandler;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.jmx.JMXLogCategories;
import cz.cuni.amis.utils.ExceptionToString;
import java.lang.management.ManagementFactory;
import java.util.Random;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.management.MBeanServer;

@AgentScoped
public class AgentLogger
implements IJMXEnabled {
    protected ILogCategories categories;
    protected LogCategory in;
    protected LogCategory out;
    protected LogCategory platform;
    protected LogCategory user;

    public AgentLogger() {
        this.categories = new LogCategories();
        this.initDefaultLoggingCategories();
    }

    public AgentLogger(LogCategories logCategories) {
        this.categories = logCategories;
        this.initDefaultLoggingCategories();
    }

    private void initDefaultLoggingCategories() {
        this.in = this.categories.getCategory(CategoryNames.IN.getName());
        this.out = this.categories.getCategory(CategoryNames.OUT.getName());
        this.user = this.categories.getCategory(CategoryNames.USER.getName());
        this.platform = this.categories.getCategory(CategoryNames.PLATFORM.getName());
    }

    public LogCategory getCategory(String name) {
        return this.categories.getCategory(name);
    }

    public ILogCategories getCategories() {
        return this.categories;
    }

    public LogCategory in() {
        return this.in;
    }

    public LogCategory out() {
        return this.out;
    }

    public LogCategory user() {
        return this.user;
    }

    public LogCategory platform() {
        return this.platform;
    }

    public void addConsoleHandlersToAllCategories() {
        this.addPublisherToAllCategories(new LogPublisher.ConsolePublisher());
    }

    public void addPublisherToAllCategories(ILogPublisher logPublisher) {
        this.addHandlerToAllCategories(new LogHandler(logPublisher));
    }

    public void addHandlerToAllCategories(Handler handler) {
        for (LogCategory category : this.categories.getCategories().values()) {
            category.addHandler(handler);
        }
    }

    public void setLevel(Level newLevel) {
        this.categories.setLevel(newLevel);
    }

    @Override
    public synchronized void enableJMX(MBeanServer mBeanServer, String jmxDomain, String type) throws JMXAlreadyEnabledException, CantStartJMXException {
        if (this.categories instanceof JMXLogCategories) {
            throw new JMXAlreadyEnabledException("AgentLogger has already JMX turned on.", this.platform(), (Object)this);
        }
        try {
            JMXLogCategories newCategories = new JMXLogCategories(this.categories, mBeanServer, jmxDomain, type);
            this.categories = newCategories;
        }
        catch (Exception e) {
            throw new CantStartJMXException(ExceptionToString.process("Can't start JMX for agent logger", e), this.platform(), (Object)this);
        }
    }

    public static void main(String[] args) throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        AgentLogger logger = new AgentLogger();
        logger.enableJMX(mbs, "JMXAgentLoggerTest", "testType");
        Random rnd = new Random(System.currentTimeMillis());
        while (true) {
            long sleep = rnd.nextInt(3000) + 1000;
            Thread.sleep(sleep);
            logger.in().info("--IN-- slept for " + sleep);
            logger.out().info("--OUT-- slept for " + sleep);
            logger.platform().info("--PLATFORM-- slept for " + sleep);
            logger.user().info("--USER-- slept for " + sleep);
        }
    }

    public static enum CategoryNames {
        IN("In"),
        OUT("Out"),
        USER("User"),
        PLATFORM("Platform");

        private String name;

        private CategoryNames(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

