/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils;

import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.utils.PogamutPlatform;
import cz.cuni.amis.pogamut.base.utils.PropertyNotFoundException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.util.Properties;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class DefaultPogamutPlatform
implements PogamutPlatform {
    Logger log = Logger.getLogger("Pogamut platform");
    static MBeanServer mBeanServer = null;
    static JMXConnectorServer cs = null;
    JMXServiceURL jmxServiceURL = null;
    Properties platformProperties = null;
    protected MBeanServerConnection mbsc = null;

    @Override
    public JMXServiceURL getMBeanServerURL() throws PogamutException {
        try {
            String hostNameProp = this.getProperty("pogamut.jmx.server.address");
            String hostName = hostNameProp != null ? hostNameProp : InetAddress.getLocalHost().getHostName();
            return new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + hostName + ":" + this.getRMIPort() + "/server");
        }
        catch (Exception ex) {
            throw new PogamutException("Error creating the JMX service URL.", ex, (Object)this);
        }
    }

    protected int getRMIPort() {
        return Integer.parseInt(this.getProperty("pogamut.jmx.server.rmi.port"));
    }

    @Override
    public MBeanServer getMBeanServer() throws PogamutException {
        try {
            if (mBeanServer == null) {
                LocateRegistry.createRegistry(this.getRMIPort());
                mBeanServer = MBeanServerFactory.createMBeanServer();
                cs = JMXConnectorServerFactory.newJMXConnectorServer(this.getMBeanServerURL(), null, mBeanServer);
                cs.start();
            }
            return mBeanServer;
        }
        catch (Exception ex) {
            throw new PogamutException("Error during JMX initialization.", (Object)ex);
        }
    }

    @Override
    public void close() throws PogamutException {
        try {
            cs.stop();
        }
        catch (IOException ex) {
            throw new PogamutException("Exception during platform shutdown.", (Object)ex);
        }
    }

    @Override
    public String getProperty(String key, String def) {
        try {
            String val = this.getProperty(key);
            return val;
        }
        catch (PropertyNotFoundException ex) {
            return def;
        }
    }

    @Override
    public String getProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            if (this.platformProperties == null) {
                Properties platformDefault = new Properties();
                try {
                    platformDefault.load(this.getClass().getResourceAsStream("/cz/cuni/amis/pogamut/PogamutPlatform.properties"));
                }
                catch (IOException ex) {
                    throw new RuntimeException("Default platform properties are missing in the jar file.", ex);
                }
                this.platformProperties = new Properties(platformDefault);
                try {
                    this.platformProperties.load(new FileReader("PogamutPlatformCustom.properties"));
                }
                catch (FileNotFoundException ex) {
                    this.log.info("Properties file not found.");
                }
                catch (IOException ex) {
                    throw new RuntimeException("I/O exception while reading the properties file.", ex);
                }
            }
            value = this.platformProperties.getProperty(key);
        }
        if (value == null) {
            value = System.getenv(key);
        }
        return value;
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() throws PogamutException {
        try {
            if (this.mbsc == null) {
                JMXServiceURL url = new JMXServiceURL(this.getProperty("pogamut.jmx.client.url"));
                JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
                this.mbsc = jmxc.getMBeanServerConnection();
            }
            return this.mbsc;
        }
        catch (IOException iOException) {
            throw new PogamutException("IO exception occured while creating remote MBeanServer connector.", (Object)iOException);
        }
    }
}

