/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.translator;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.exceptions.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.exceptions.TranslatorException;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.parser.IWorldMessageParser;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldEventOutput;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldMessageTranslator;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import java.util.LinkedList;
import java.util.Queue;

@AgentScoped
public class WorldEventOutput
implements IWorldEventOutput {
    protected IWorldMessageParser parser = null;
    protected AgentLogger agentLogger = null;
    protected LogCategory log = null;
    protected IWorldMessageTranslator handler = null;
    private Queue<IWorldChangeEvent> worldEventQueue = new LinkedList<IWorldChangeEvent>();

    @Inject
    public WorldEventOutput(IWorldMessageParser parser, IWorldMessageTranslator messageHandler, AgentLogger logger) {
        this.agentLogger = logger;
        this.log = this.agentLogger.in();
        this.parser = parser;
        if (this.parser == null) {
            throw new IllegalArgumentException("parser can't be null");
        }
        this.handler = messageHandler;
        if (this.handler == null) {
            throw new IllegalArgumentException("handler can't be null");
        }
    }

    @Override
    public void start() throws CommunicationException {
        this.parser.start();
    }

    @Override
    public void stop() {
        this.parser.stop();
    }

    @Override
    public void kill() {
        this.stop();
    }

    protected IWorldChangeEvent[] processMessage(InfoMessage message) throws TranslatorException {
        return this.handler.processMessage(message);
    }

    @Override
    public synchronized IWorldChangeEvent getEvent() throws CommunicationException {
        if (this.worldEventQueue.size() > 0) {
            return this.worldEventQueue.poll();
        }
        IWorldChangeEvent[] worldEvents = null;
        while (worldEvents == null || worldEvents.length == 0) {
            InfoMessage message = null;
            while (message == null) {
                message = this.parser.parse();
            }
            worldEvents = this.processMessage(message);
        }
        for (int i = 1; i < worldEvents.length; ++i) {
            this.worldEventQueue.add(worldEvents[i]);
        }
        return worldEvents[0];
    }
}

