/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.mediator;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.exceptions.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.exceptions.MediatorException;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediatorOutput;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldEventOutput;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.flag.WaitForFlagChange;
import java.util.logging.Level;

@AgentScoped
public class Mediator
implements IMediator {
    public static final String WORKER_THREAD_NAME_PREFIX = "Mediator.Worker";
    public static final String MEDIATOR_LOG_PREFIX = "Mediator: ";
    protected IMediatorOutput receiver = null;
    protected Thread workerThread = null;
    protected Worker worker = null;
    protected Object startSynchronization = new Object();
    private AgentLogger agentLogger = null;
    private LogCategory log = null;
    private IWorldEventOutput producer;
    private Flag<Boolean> running = new Flag<Boolean>(false);

    @Inject
    public Mediator(IWorldEventOutput producer, IMediatorOutput receiver, AgentLogger logger) throws CommunicationException {
        this.agentLogger = logger;
        this.log = this.agentLogger.in();
        this.producer = producer;
    }

    @Override
    public void setMediatorOutput(IMediatorOutput receiver) {
        this.receiver = receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws CommunicationException {
        Object object = this.startSynchronization;
        synchronized (object) {
            if (this.workerThread != null) {
                throw new MediatorException("Mediator worker thread already exists, can't start.", this.log, (Object)this);
            }
            this.producer.start();
            this.log.finer("Mediator: starting mediator thread (Mediator.Worker).");
            this.worker = new Worker();
            this.workerThread = new Thread((Runnable)this.worker, "Mediator.Worker (" + String.valueOf(this.producer) + ")");
            this.workerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.startSynchronization;
        synchronized (object) {
            if (this.worker != null) {
                this.worker.stop();
            }
            try {
                new WaitForFlagChange<Boolean>(this.running, false).await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() {
        Object object = this.startSynchronization;
        synchronized (object) {
            if (this.worker != null) {
                this.worker.kill();
            }
            this.producer.stop();
            try {
                new WaitForFlagChange<Boolean>(this.running, false).await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean isRunning() {
        return this.running.getFlag();
    }

    @Override
    public ImmutableFlag<Boolean> getRunning() {
        return this.running.getImmutable();
    }

    public LogCategory getLogger() {
        return this.log;
    }

    private class Worker
    implements Runnable {
        private volatile boolean shouldRun = true;

        private Worker() {
        }

        public void stop() {
            this.shouldRun = false;
        }

        public void kill() {
            this.stop();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Thread worker = Mediator.this.workerThread;
            if (worker != null && worker.isAlive()) {
                worker.interrupt();
            }
        }

        @Override
        public void run() {
            Mediator.this.running.setFlag(true);
            this.logWorker(Level.INFO, "worker thread (Mediator.Worker) started.");
            try {
                while (this.shouldRun && !Thread.interrupted()) {
                    IMediatorOutput currentHandler = Mediator.this.receiver;
                    if (currentHandler == null) {
                        if (this.shouldRun) {
                            this.logWorker(Level.SEVERE, "message receiver lost (is null).");
                        }
                        break;
                    }
                    IWorldChangeEvent worldEvent = null;
                    try {
                        worldEvent = Mediator.this.producer.getEvent();
                        this.logWorker(Level.INFO, "world event received: " + String.valueOf(worldEvent), worldEvent);
                    }
                    catch (CommunicationException ce) {
                        ce.logExceptionOnce(Mediator.this.log);
                        if (this.shouldRun) {
                            this.logWorker(Level.SEVERE, "exception occured, shutting down");
                        }
                        break;
                    }
                    catch (Exception e) {
                        if (this.shouldRun) {
                            this.logWorker(Level.SEVERE, ExceptionToString.process("exception raised in world event output (" + Mediator.this.producer.toString() + ")", e));
                        }
                        break;
                    }
                    if (this.shouldRun && !Thread.interrupted()) {
                        try {
                            currentHandler.notify(worldEvent);
                            continue;
                        }
                        catch (Exception e) {
                            this.logWorker(Level.SEVERE, ExceptionToString.process("exception raised in message receiver (" + currentHandler.toString() + ")", e));
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.logWorker(Level.SEVERE, ExceptionToString.process("unhandled exception caught", e));
            }
            this.shouldRun = false;
            Mediator.this.worker = null;
            Mediator.this.workerThread = null;
            try {
                Mediator.this.producer.stop();
            }
            catch (Exception e) {
                this.logWorker(Level.SEVERE, ExceptionToString.process("can't close event output", e));
            }
            Mediator.this.running.setFlag(false);
            this.logWorker(Level.WARNING, "worker stopped.");
        }

        private void logWorker(Level level, String message) {
            Mediator.this.log.log(level, "Mediator.Worker: " + message);
        }

        private void logWorker(Level level, String message, Object obj) {
            if (obj == null) {
                Mediator.this.log.log(level, "Mediator.Worker: " + message);
            } else {
                Mediator.this.log.log(level, "Mediator.Worker: " + message, obj);
            }
        }
    }
}

