/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.commands;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldWriterProvider;
import cz.cuni.amis.pogamut.base.communication.exceptions.CommandException;
import cz.cuni.amis.pogamut.base.communication.exceptions.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.exceptions.ConnectionException;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import java.io.PrintWriter;

@AgentScoped
public class CommandSerializer
implements ICommandSerializer {
    private PrintWriter writer = null;
    private IWorldWriterProvider writerProvider;
    protected AgentLogger agentLogger;
    protected LogCategory log;

    @Inject
    public CommandSerializer(IWorldWriterProvider writerProvider, AgentLogger logger) {
        this.agentLogger = logger;
        this.log = this.agentLogger.out();
        this.writerProvider = writerProvider;
    }

    @Override
    public void start() throws ConnectionException {
        this.writer = new PrintWriter(this.writerProvider.getWriter());
    }

    @Override
    public void stop() {
        this.writer.close();
    }

    @Override
    public void kill() {
        this.stop();
    }

    protected String serializeCommand(CommandMessage command) {
        return command.toMessage() + "\r\n";
    }

    @Override
    public void sendCommand(CommandMessage command) throws CommunicationException {
        this.log.fine("Sending command: " + command);
        if (this.writer == null) {
            throw new CommandException("Writer not initialized, start() not called?", this.log, (Object)this);
        }
        this.writer.print(this.serializeCommand(command));
        this.writer.flush();
    }
}

