/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.worldview;

import cz.cuni.amis.pogamut.base.agent.worldview.EventDrivenWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.ILockableWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.IWorldObjectUpdateEvent;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import java.util.ArrayList;
import java.util.List;

@AgentScoped
public class LockableWorldView
extends EventDrivenWorldView
implements ILockableWorldView {
    private Boolean lock = false;
    protected List<IWorldChangeEvent> eventsToProcess = new ArrayList<IWorldChangeEvent>();
    protected boolean lockEvents = false;

    public LockableWorldView(IMediator messageSource, AgentLogger log) {
        super(messageSource, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        Boolean bl = this.lock;
        synchronized (bl) {
            this.lock = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        Boolean bl = this.lock;
        synchronized (bl) {
            this.lock = false;
            for (IWorldChangeEvent event : this.eventsToProcess) {
                super.notify(event);
            }
            this.eventsToProcess.clear();
        }
    }

    @Override
    public boolean isLocked() {
        return this.lock;
    }

    public void setLockEvents(boolean lockEvents) {
        this.lockEvents = lockEvents;
    }

    public boolean isLockEvents() {
        return this.lockEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent(IWorldChangeEvent event) {
        Boolean bl = this.lock;
        synchronized (bl) {
            if (this.lock.booleanValue()) {
                if (!this.lockEvents && !(event instanceof IWorldObjectUpdateEvent)) {
                    this.eventsToProcess.add(event);
                } else {
                    super.notify(event);
                }
            }
        }
    }
}

